unit Trexdm01;

{
$Log:   W:/users/prodigy/prodig~1/archive/trex/trexdm01.pav  $
 * 
 *    Rev 1.1   07 Apr 1996 18:30:52   PaulK
 * Work in progress on demos
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, ExtCtrls, T_Rex, Gauges;

type
  TForm1 = class(TForm)
    Rex1: TRex;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    Bevel1: TBevel;
    Button1: TButton;
    Button2: TButton;
    BitBtn1: TBitBtn;
    Bevel2: TBevel;
    Label2: TLabel;
    Label3: TLabel;
    Gauge1: TGauge;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Rex1EOF(Sender: TObject);
    procedure Rex1Match(Sender: TObject; const Expression: Word;
      const Token: String; const InputLine: PChar; const Offset,
      Length: Word);
    procedure Rex1AfterLineMatch(Sender: TObject);
    procedure Rex1BeforeLineMatch(Sender: TObject);
    procedure Rex1BOF(Sender: TObject);
  private
    { Private declarations }
    CommentCount: word; {counts the number of comment-only lines}
    InComment: boolean; {true while we are in a multi-line comment}
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
if OpenDialog1.Execute then
  begin
  Rex1.FileSpec := OpenDialog1.Filename;
  Button2.Enabled := true;
  end
else
  Button2.Enabled := false;

end;

procedure TForm1.Button2Click(Sender: TObject);
begin
Screen.Cursor := crHourglass;
Rex1.Scan;
Screen.Cursor := crDefault;
end;

procedure TForm1.Rex1EOF(Sender: TObject);
begin
Gauge1.Progress := Gauge1.MaxValue;
With Rex1 do
  Label2.Caption :=
  Format('The file %s contains %d lines of which %d consist entirely of comments. Proportion of comment lines is %5.2f%%.',
  [Filename, ScanLineNumber, CommentCount, CommentCount/ScanlineNumber*100.0]);
end;

procedure TForm1.Rex1Match(Sender: TObject; const Expression: Word;
  const Token: String; const InputLine: PChar; const Offset, Length: Word);
begin
case expression of
0: {first expression, comment begins and ends on the same line}
   begin
   inc(CommentCount);
   Rex1.SeekEoln; {skip further processing of this line}
   end;
1: {Comment begins on this line}
   begin
   InComment := true;
   inc(CommentCount);
   Rex1.SeekEoln; {skip further processing of this line}
   end;
2: {Comment begins on this line, but there's some non-comment stuff before it}
   begin
   InComment := true;
   Rex1.SeekEoln {skip further processing}
   end;
3: {Comment ends on this line, with only spaces after}
   begin
   if InComment then {it didn't start on this line, so}
     inc(CommentCount);
   InComment := false;
   Rex1.SeekEoln {skip further processing}
   end;
4: {Comment ends on this line, but there's some non-comment stuff}
   begin
   InComment := false;
   end;

   end; {case}
end;

procedure TForm1.Rex1AfterLineMatch(Sender: TObject);
{
This gets called only if the OnMatch event didn't do a SeekEoln.
It increments the counter in the interior of a multi-line comment.
The first and last lines are counted in OnMatch, not here.
}
begin
if InComment then
  inc(CommentCount);
end;

procedure TForm1.Rex1BeforeLineMatch(Sender: TObject);
begin
Label2.Caption := Format('Scanning %s  line %4d',[Rex1.Filename,Rex1.ScanLineNumber]);
Label2.Refresh;
Gauge1.Progress := Rex1.FilePosition;
end;

procedure TForm1.Rex1BOF(Sender: TObject);
begin
InComment := false;
CommentCount := 0;
Gauge1.MaxValue := Rex1.Filesize;
end;

end.
